/* FILE: mhalfsp.h                              (D. Tottingham  12/27/89)

This is an include file of defines, data structure definitions and
external declarations that are common in the mhalfsp module.

*/

#ifndef _MHALFSP_
#define _MHALFSP_

/************************************************************************
                               INCLUDES

************************************************************************/
#include "mconst.h"
#include "suds.h"


/************************************************************************
                                DEFINES

************************************************************************/
#define DETERMINANT_LIMIT       0.00001
#define CRITICAL_PHI            4
#define HALFSPACE_VELOCITY      6.5


/************************************************************************
                         EXTERNAL DECLARATIONS

These functions can be called from all modules that include this file.

************************************************************************/
PUBLIC void hs_initialize ();
PUBLIC FLAG hs_locate_event (SUDS_ORIGIN far *);
PUBLIC void hs_set_CriticalPhi (unsigned int);
PUBLIC void hs_set_HalfspaceVelocity (double);

#endif
